//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
// UserStringHeap.cpp : plik implementacji
//

#include "stdafx.h"
#include "AssemblyDoc.h"
#include "AssemblyView.h"
#include "UserStringHeapPage.h"


// Okno dialogowe CUserStringHeap

IMPLEMENT_DYNAMIC(CUserStringHeapPage, CPropertyPage)
CUserStringHeapPage::CUserStringHeapPage()
	: CPropertyPage(CUserStringHeapPage::IDD)
{
}

CUserStringHeapPage::~CUserStringHeapPage()
{
}

void CUserStringHeapPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_USERSTRINGLIST, m_ctrlUserStringList);
}


BEGIN_MESSAGE_MAP(CUserStringHeapPage, CPropertyPage)
END_MESSAGE_MAP()


// Procedury obsugi wiadomoci CUserStringHeap

ULONG CountCharacters(WCHAR *str, ULONG strLength, bool *bUnprint)
{
	ULONG count = 0;
	*bUnprint = false;
	while (strLength)
	{   
		switch (*str)
		{
		case 0:
		case L'\r':
		case L'\n':
		case L'\t':
			count += 2;
			break;
		default:
			if (iswprint(*str))
				count += 1;
			else 
			{
				*bUnprint = true;
				count += 1;
			}
			break;
		}
		++str;
		--strLength;
	}
	return count;
}

void CUserStringHeapPage::DumpUserStrings(IMetaDataImport* pImport, CListCtrl *pList)
{
    HCORENUM    stringEnum = NULL;      // Enumerator cigu.
    mdString    Strings[ENUM_BUFFER_SIZE]; // etony cigw z enumeratora.
    WCHAR		rUserString[MAX_STRING_LENGTH];			// Bufor do odbioru cigw.
    WCHAR       *szUserString;          // Roboczy wskanik bufora.
    ULONG       chUserString;           // Dugo cigu uytkownika.
    ULONG       chBuf;                  // Zapisana dugo cigu uytkownika.
    ULONG       count;                  // Elementy zwrcone z enumeratora.
    ULONG       totalCount = 1;         // Biecy licznik cigw.
	ULONG       itemIndex = (ULONG)-1;
	TCHAR       cBuffer[64];
    bool        bUnprint = false;       // Czy znaleziono znak, ktry nie jest wywietlany?
    HRESULT     hr;                     // Wynik.

	memset(rUserString, 0, sizeof(rUserString));

    while (SUCCEEDED(hr = pImport->EnumUserStrings(&stringEnum,
                                                   Strings,
												   NumItems(Strings),
												   &count)) &&
           count > 0)
    {
        if (totalCount == 1)
        {
			// Jeli licznik ma warto 1, to jest to pusty cig, ktry nie musi by wywietlany.
        }
        for (ULONG i = 0; i < count; i++, totalCount++)
        {
            do
			{ 
				// Umieszczenie cigu w istniejcym buforze.
                hr = pImport->GetUserString( Strings[i],
					                         rUserString,
											 sizeof(rUserString), 
											 &chUserString);
                if (hr == CLDB_S_TRUNCATION)
                {   
					// Za may bufor, prba powikszenia.
					TRACE(_T("Za may bufor, prba powikszenia.\n"));
                    continue;
                }
            } while (0);

            if (FAILED(hr))
			{
				TRACE(_T("Dziaanie GetUserString nie powiodo si.\n"));
			}

			// Cig
            szUserString = rUserString;
			// Dugo cigu
            chBuf = chUserString;

			wsprintf(cBuffer, _T("%d"), i);
			itemIndex = pList->InsertItem(itemIndex + 1, cBuffer);

			wsprintf(cBuffer, _T("0x%8X"),  Strings[i]);
			pList->SetItemText(itemIndex, 1, cBuffer);

			ULONG stringLength = CountCharacters(szUserString, chUserString, &bUnprint);

			LPWSTR stringBuffer = new WCHAR[stringLength + 1];
			memset(stringBuffer, 0, stringLength + 1);
            while (chUserString)
            {   
                switch (*szUserString)
                {
                case 0:
                    wcscat(stringBuffer, L"\\0");
					break;
                case L'\r':
                    wcscat(stringBuffer, L"\\r");
					break;
                case L'\n':
                    wcscat(stringBuffer, L"\\n");
					break;
                case L'\t':
                    wcscat(stringBuffer, L"\\t");
					break;
                default:
                    if (iswprint(*szUserString))
					{
 					   wsprintf(cBuffer, _T("%lc"),  *szUserString);
                       wcscat(stringBuffer, cBuffer);
					}
                    else 
                    {
                        bUnprint = true;
						wcscat(stringBuffer, L".");
                    }
                    break;
                }
                ++szUserString;
                --chUserString;
            }
			pList->SetItemText(itemIndex, 2, stringBuffer);
			delete [] stringBuffer;
		}
    }
    if (stringEnum != NULL)
        pImport->CloseEnum(stringEnum);
}


BOOL CUserStringHeapPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	CString strItemLabel = _T("Item");
	CString strIndex = _T("Token");
	CString strString = _T("String");

	CRect rect;
	// Wstawienie trzech kolumn (tryb raportu) i modyfikacja nowych elementw nagwka
	m_ctrlUserStringList.GetWindowRect(&rect);
	m_ctrlUserStringList.InsertColumn(0, strItemLabel, LVCFMT_LEFT,
		                              rect.Width() * 1/6, 0);
	m_ctrlUserStringList.InsertColumn(1, strIndex, LVCFMT_LEFT,
		                              rect.Width() * 1/6, 1);
	m_ctrlUserStringList.InsertColumn(2, strString, LVCFMT_LEFT,
		                              rect.Width() * 2/3, 2);

	// Wypenienie danymi
	CPropertySheet *pPropertySheet = STATIC_DOWNCAST(CPropertySheet, GetParent());
	CAssemblyView* pView = STATIC_DOWNCAST(CAssemblyView, pPropertySheet->GetParent());
	CAssemblyDoc* pDoc = pView->GetDocument();
	IMetaDataImport* pImport  = pDoc->MetaDataImportInterface();

	DumpUserStrings(pImport, &m_ctrlUserStringList);

	pImport->Release();

	return TRUE;  // zwrcenie TRUE, chyba e ognisko ustawiono na element sterujcy
}
